import { StarXpandCommand } from "star-io10-web";

export class LabelSample08_For203dpiAnd300dpi_NutritionFactsLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(3, 3),
                )
                .actionPrintText("Nutrition Facts\n"),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText(
              "${servings_per_container} servings per container\n",
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .actionPrintText("Serving size")
                .actionPrintText(
                  "${serving_size}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    36,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.RuledLineParameter(
                    72.0,
                  ).setThickness(4.0),
                )
                .actionPrintText("Amount per serving\n")
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(3, 3),
                )
                .actionPrintText("${amount_per_serving}\n"),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(2.0),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
                .styleBold(true)
                .actionPrintText("% Daily Value*\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.RuledLineParameter(
                    72.0,
                  ).setThickness(0.1),
                )
                .actionPrintText(
                  "${item1_list.name} ${item1_list.amount}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(44),
                )
                .actionPrintText(
                  "${item1_list.percentage}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    4,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(4.0),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item2_list.name} ${item2_list.amount}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(44),
                )
                .actionPrintText(
                  "${item2_list.percentage}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    4,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.RuledLineParameter(
                    72.0,
                  ).setThickness(0.1),
                ),
            )
            .actionPrintText(
              "* The % Daily Value (DV) tells you how much a nutrient in a serving of food contributes to a daily diet. 2,000 calories a day is used for general nutrition advice.\n" +
                "↑ One Serving adds 17g of sugar to your diet and represents 34% of the daily value for addded sugars.\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "servings_per_container" : 16,
    "serving_size" : "1 Tbsp.(21g)",
    "amount_per_serving" : "Calories      60",
    "item1_list" : [
        {
            "name" : "Total Fat",
            "amount" : "0g",
            "percentage" : "0%"
        },
        {
            "name" : "  Saturated Fat",
            "amount" : "0g",
            "percentage" : "0%"
        },
        {
            "name" : "  Trans Fat",
            "amount" : "0g",
            "percentage" : ""
        },
        {
            "name" : "Cholesterol",
            "amount" : "0mg",
            "percentage" : "0%"
        },
        {
            "name" : "Sodium",
            "amount" : "0mg",
            "percentage" : "0%"
        },
        {
            "name" : "Total Carbohydrate",
            "amount" : "17g",
            "percentage" : "6%"
        },
        {
            "name" : "  Dietary Fiber",
            "amount" : "0g",
            "percentage" : "0%"
        },
        {
            "name" : "  Total Sugars",
            "amount" : "17g",
            "percentage" : ""
        },
        {
            "name" : "",
            "amount" : "",
            "percentage" : "34%"
        },
        {
            "name" : "Protein",
            "amount" : "0g",
            "percentage" : ""
        }
    ],
    "item2_list" : [
        {
            "name" : "Vitamin D",
            "amount" : "0mcg",
            "percentage" : "0%"
        },
        {
            "name" : "Calcium",
            "amount" : "0mg",
            "percentage" : "0%"
        },
        {
            "name" : "Iron",
            "amount" : "0mg",
            "percentage" : "0%"
        },
        {
            "name" : "Potassium",
            "amount" : "0mg",
            "percentage" : "0%"
        }
    ]
}`,
    );
  }
}
